unit IBAccess;

interface
uses Classes, IBDatabase, IBCustomDataSet, IBQuery, SysUtils;
const
 DatabaseNameConstant='localhost:C:\Program Files\Common Files\Borland Shared\Data\EMPLOYEE.GDB';
 DbPassword ='masterkey';
 DbUser='sysdba';
 DbQueryConstant='Select * From Employee';


type
  T2dString = Array of Array of String;

  TIBSqlQuery = class(TObject)
  private
    FIBDatabase: TIBDatabase;
    FIBTransaction: TIBTransaction;
    FIBQuery: TIBQuery;
    procedure Login(Database: TIBDatabase; LoginParams: TStrings);
  public
    constructor Create;
    destructor Destroy; override;
    procedure PopulateArray(const ASQLString: string; var AStrArray: T2dString); overload;
  end;

implementation

{ TIBSqlQuery }

constructor TIBSqlQuery.Create;
begin
  FIBDatabase := TIBDatabase.Create(nil);
  FIBDatabase.DatabaseName:=DatabaseNameConstant;

  FIBTransaction := TIBTransaction.Create(nil);
  FIBTransaction.DefaultDatabase:=FIBDatabase;
  FIBQuery := TIBQuery.Create(nil);
  FIBQuery.Database:=FIBDatabase;
  FIBQuery.Transaction:=FIBTransaction;
  FIBDatabase.OnLogin:= LogIn;
  FIBDatabase.DefaultTransaction:=FIBTransaction;
  //FIBDatabase.LoginPrompt:=false;
end;

destructor TIBSqlQuery.Destroy;
begin
  FIBQuery.Free;
  FIBTransaction.Free;
  FIBDatabase.Free;
  inherited;
end;

procedure TIBSqlQuery.Login(Database: TIBDatabase; LoginParams: TStrings);
begin
  LoginParams.Add('user_name='+DbUser);
  LoginParams.Add('password='+DbPassword);
//  FIBDatabase.Params.Add('password='+DbPassword);
//  FIBDatabase.Params.Add('sql_role_name=finance');
//  FIBDatabase.Params.Add('lc_ctype=WIN1252');

end;

procedure TIBSqlQuery.PopulateArray(const ASQLString: string;
  var AStrArray: T2dString);
var
  i, j, n, m: Integer;
begin
 try
  FIBQuery.SQL.Clear;
  FIBQuery.SQL.Add(ASQLString);
  FIBQuery.Open;
  n := 5;// FIBQuery.RecordCount;
  m := FIBQuery.FieldCount;
  SetLength(AStrArray, n);
  i := 0;
  FIBQuery.First;
  while not FIBQuery.Eof do
    begin
      if i> n-1 then
        Begin
          inc(n,5);
          SetLength(AStrArray, n);
        end;
      SetLength(AStrArray[i], m);
      for j := 0 to m - 1 do AStrArray[i, j] := FIBQuery.Fields[j].AsString;
      FIBQuery.Next;
      Inc(i);
    end;
  SetLength(AStrArray, i);
  FIBQuery.Close;
 except
  On e:Exception do
    Raise Exception.Create(E.Message);
 end;
end;

end.

